/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.world;

import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.world.ModConfiguredFeature;
import com.st0x0ef.stellaris.common.world.OrePlacement;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> STEEL_ORE_PLACED_KEY = ModPlacedFeatures.createKey("steel_ore");
    public static final ResourceKey<PlacedFeature> STEEL_ORE_DEEPSLATE_PLACED_KEY = ModPlacedFeatures.createKey("steel_ore_deepslate");
    public static final ResourceKey<PlacedFeature> LAKE_OIL_UNDERGROUND = ModPlacedFeatures.createKey("lake_oil_underground");
    public static final ResourceKey<PlacedFeature> LAKE_OIL_SURFACE = ModPlacedFeatures.createKey("lake_oil_surface");
    public static final ResourceKey<PlacedFeature> MARS_DIAMOND_PLACED_KEY = ModPlacedFeatures.createKey("mars_diamond_ore");
    public static final ResourceKey<PlacedFeature> MARS_ICE_SHARD_PLACED_KEY = ModPlacedFeatures.createKey("mars_ice_shard_ore");
    public static final ResourceKey<PlacedFeature> MARS_IRON_PLACED_KEY = ModPlacedFeatures.createKey("mars_iron_ore");
    public static final ResourceKey<PlacedFeature> MARS_OSTRUM_PLACED_KEY = ModPlacedFeatures.createKey("mars_ostrum_ore");
    public static final ResourceKey<PlacedFeature> MARS_THARSITE_PLACED_KEY = ModPlacedFeatures.createKey("mars_tharsite_ore");
    public static final ResourceKey<PlacedFeature> MERCURY_IRON_PLACED_KEY = ModPlacedFeatures.createKey("mercury_iron_ore");
    public static final ResourceKey<PlacedFeature> MERCURY_URANIUM_PLACED_KEY = ModPlacedFeatures.createKey("mercury_uranium_ore");
    public static final ResourceKey<PlacedFeature> MERCURY_SOLERIUM_PLACED_KEY = ModPlacedFeatures.createKey("mercury_solerium_ore");
    public static final ResourceKey<PlacedFeature> MOON_DESH_PLACED_KEY = ModPlacedFeatures.createKey("moon_desh_ore");
    public static final ResourceKey<PlacedFeature> MOON_ICE_SHARD_PLACED_KEY = ModPlacedFeatures.createKey("moon_ice_shard_ore");
    public static final ResourceKey<PlacedFeature> MOON_IRON_PLACED_KEY = ModPlacedFeatures.createKey("moon_iron_ore");
    public static final ResourceKey<PlacedFeature> MOON_SOUL_SOIL_PLACED_KEY = ModPlacedFeatures.createKey("moon_soul_soil");
    public static final ResourceKey<PlacedFeature> MOON_STEEL_PLACED_KEY = ModPlacedFeatures.createKey("moon_steel_ore");
    public static final ResourceKey<PlacedFeature> MOON_VINE_PLACED_KEY = ModPlacedFeatures.createKey("moon_vine");
    public static final ResourceKey<PlacedFeature> MOON_CAVES = ModPlacedFeatures.createKey("moon_caves");
    public static final ResourceKey<PlacedFeature> VENUS_COAL_PLACED_KEY = ModPlacedFeatures.createKey("venus_coal_ore");
    public static final ResourceKey<PlacedFeature> VENUS_DIAMOND_PLACED_KEY = ModPlacedFeatures.createKey("venus_diamond_ore");
    public static final ResourceKey<PlacedFeature> VENUS_GOLD_PLACED_KEY = ModPlacedFeatures.createKey("venus_gold_ore");
    public static final ResourceKey<PlacedFeature> VENUS_CORRONIUM_PLACED_KEY = ModPlacedFeatures.createKey("venus_corronium_ore");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, STEEL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.STEEL_ORE_KEY), OrePlacement.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, STEEL_ORE_DEEPSLATE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.STEEL_ORE_DEEPSLATE_ORE_KEY), OrePlacement.commonOrePlacement(17, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)25))));
        ModPlacedFeatures.register(context, MARS_DIAMOND_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MARS_DIAMOND_ORE_KEY), OrePlacement.commonOrePlacement(14, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, MARS_ICE_SHARD_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MARS_ICE_SHARD_ORE_KEY), OrePlacement.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-32), (VerticalAnchor)VerticalAnchor.aboveBottom((int)32))));
        ModPlacedFeatures.register(context, MARS_IRON_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MARS_IRON_ORE_KEY), OrePlacement.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, MARS_OSTRUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MARS_OSTRUM_ORE_KEY), OrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, MARS_THARSITE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MARS_THARSITE_ORE_KEY), OrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-32), (VerticalAnchor)VerticalAnchor.aboveBottom((int)32))));
        ModPlacedFeatures.register(context, MERCURY_IRON_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MERCURY_IRON_ORE_KEY), OrePlacement.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
        ModPlacedFeatures.register(context, MERCURY_URANIUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MERCURY_URANIUM_ORE_KEY), OrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
        ModPlacedFeatures.register(context, MERCURY_SOLERIUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MERCURY_SOLERIUM_ORE_KEY), OrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
        ModPlacedFeatures.register(context, MOON_DESH_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_DESH_ORE_KEY), OrePlacement.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, MOON_ICE_SHARD_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_ICE_SHARD_ORE_KEY), OrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, MOON_IRON_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_IRON_ORE_KEY), OrePlacement.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, MOON_SOUL_SOIL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_SOUL_SOIL_KEY), OrePlacement.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)100))));
        ModPlacedFeatures.register(context, MOON_STEEL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_IRON_ORE_KEY), OrePlacement.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, VENUS_COAL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.VENUS_COAL_ORE_KEY), OrePlacement.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
        ModPlacedFeatures.register(context, VENUS_DIAMOND_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.VENUS_DIAMOND_ORE_KEY), OrePlacement.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, VENUS_GOLD_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.VENUS_GOLD_ORE_KEY), OrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, VENUS_CORRONIUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.VENUS_CORRONIUM_ORE_KEY), OrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-32))));
        ModPlacedFeatures.register(context, MOON_VINE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_VINES), List.of(new PlacementModifier[]{CountPlacement.of((int)188), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()}));
        ModPlacedFeatures.registerOne(context, LAKE_OIL_UNDERGROUND, configuredFeatures.getOrThrow(ModConfiguredFeature.LAKE_OIL), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)9), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.top())), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE), (BlockPredicate)BlockPredicate.insideWorld((Vec3i)new BlockPos(0, -5, 0))), (int)32), SurfaceRelativeThresholdFilter.of((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-5), BiomeFilter.biome()});
        ModPlacedFeatures.registerOne(context, LAKE_OIL_SURFACE, configuredFeatures.getOrThrow(ModConfiguredFeature.LAKE_OIL), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)200), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        ModPlacedFeatures.registerOne(context, MOON_CAVES, configuredFeatures.getOrThrow(ModConfiguredFeature.MOON_CAVES), new PlacementModifier[]{CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocationUtils.id(name));
    }

    private static void registerOne(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier[] modifiers) {
        ModPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

